<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Journey of Life GCC - Empowering Lives Through Knowledge')</title>
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --primary-blue: #1e3a8a;
            --secondary-blue: #3b82f6;
            --accent-orange: #f97316;
            --accent-green: #10b981;
            --bg-mint: #d1f4e0;
            --bg-light-blue: #e0f2fe;
            --text-dark: #1f2937;
            --text-muted: #6b7280;
            --white: #ffffff;
        }

        body {
            font-family: 'Inter', sans-serif;
            line-height: 1.6;
            color: var(--text-dark);
            background: var(--bg-mint);
        }

        /* Navigation */
        .navbar {
            background: white;
            padding: 1rem 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 1.5rem;
        }

        .nav-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            text-decoration: none;
        }

        .logo img {
            height: 60px;
            width: auto;
        }

        .logo-text {
            font-size: 1.1rem;
            font-weight: 700;
            color: var(--primary-blue);
            line-height: 1.2;
        }

        .nav-menu {
            display: flex;
            list-style: none;
            gap: 2.5rem;
            align-items: center;
        }

        .nav-menu a {
            color: var(--text-dark);
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s;
            font-size: 1rem;
        }

        .nav-menu a:hover,
        .nav-menu a.active {
            color: var(--secondary-blue);
        }

        .btn-consultation {
            background: var(--secondary-blue);
            color: white;
            padding: 0.75rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            border: none;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s;
        }

        .btn-consultation:hover {
            background: var(--primary-blue);
            transform: translateY(-2px);
        }

        .search-icon {
            font-size: 1.25rem;
            color: var(--text-dark);
            cursor: pointer;
        }

        /* Mobile menu toggle */
        .mobile-toggle {
            display: none;
            font-size: 1.5rem;
            background: none;
            border: none;
            cursor: pointer;
        }

        /* Hero Section */
        .hero {
            background: var(--bg-light-blue);
            padding: 4rem 0;
            position: relative;
        }

        .hero-content {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 3rem;
            align-items: center;
        }

        .hero-left img {
            width: 100%;
            height: auto;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }

        .hero-text {
            padding: 2rem;
        }

        .hero-badge {
            color: var(--accent-orange);
            font-weight: 600;
            font-size: 0.95rem;
            margin-bottom: 1rem;
            display: inline-block;
        }

        .hero h1 {
            font-size: 3rem;
            font-weight: 800;
            color: var(--primary-blue);
            margin-bottom: 1.5rem;
            line-height: 1.2;
        }

        .hero p {
            font-size: 1.1rem;
            color: var(--text-muted);
            margin-bottom: 1rem;
            line-height: 1.8;
        }

        .hero-stats {
            display: flex;
            align-items: center;
            gap: 1.5rem;
            margin-top: 2rem;
        }

        .stat-item {
            background: white;
            padding: 1.5rem;
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
            text-align: center;
            min-width: 150px;
        }

        .stat-number {
            font-size: 2rem;
            font-weight: 800;
            color: var(--primary-blue);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.25rem;
        }

        .stat-label {
            color: var(--text-muted);
            font-size: 0.9rem;
            margin-top: 0.5rem;
        }

        /* About Section */
        .about-section {
            background: white;
            padding: 5rem 0;
        }

        .about-content {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 4rem;
            align-items: center;
        }

        .about-images {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1.5rem;
            position: relative;
        }

        .about-image {
            width: 100%;
            height: 250px;
            object-fit: cover;
            border-radius: 15px;
            box-shadow: 0 8px 20px rgba(0,0,0,0.1);
        }

        .about-stats-badge {
            position: absolute;
            bottom: 1rem;
            left: 1rem;
            background: white;
            padding: 1.5rem;
            border-radius: 12px;
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .badge-icon {
            font-size: 2.5rem;
            color: var(--accent-orange);
        }

        .section-badge {
            color: var(--accent-orange);
            font-weight: 600;
            font-size: 0.95rem;
            margin-bottom: 1rem;
            display: inline-block;
        }

        .section-title {
            font-size: 2.5rem;
            font-weight: 800;
            color: var(--primary-blue);
            margin-bottom: 1.5rem;
            line-height: 1.3;
        }

        .section-text {
            color: var(--text-muted);
            font-size: 1.05rem;
            line-height: 1.8;
            margin-bottom: 1.5rem;
        }

        .highlight-text {
            color: var(--primary-blue);
            font-weight: 600;
        }

        /* Services Section */
        .services-section {
            background: var(--bg-light-blue);
            padding: 5rem 0;
        }

        .section-header {
            text-align: center;
            margin-bottom: 3rem;
        }

        .services-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 2rem;
            margin-top: 3rem;
        }

        .service-card {
            background: white;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 8px 25px rgba(0,0,0,0.08);
            transition: transform 0.3s, box-shadow 0.3s;
            cursor: pointer;
        }

        .service-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 35px rgba(0,0,0,0.15);
        }

        .service-image {
            width: 100%;
            height: 220px;
            object-fit: cover;
        }

        .service-content {
            padding: 2rem;
        }

        .service-icon {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            margin-bottom: 1rem;
        }

        .service-icon i {
            font-size: 1.75rem;
            color: var(--primary-blue);
        }

        .service-title {
            font-size: 1.35rem;
            font-weight: 700;
            color: var(--primary-blue);
            margin-bottom: 1rem;
        }

        .service-description {
            color: var(--text-muted);
            font-size: 0.95rem;
            line-height: 1.7;
            margin-bottom: 1.5rem;
        }

        .read-more {
            color: #dc2626;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: gap 0.3s;
        }

        .read-more:hover {
            gap: 0.75rem;
        }

        /* Blog Section */
        .blog-section {
            background: white;
            padding: 5rem 0;
        }

        .blog-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 2rem;
            margin-top: 3rem;
        }

        .blog-card {
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 6px 20px rgba(0,0,0,0.08);
            transition: all 0.3s;
        }

        .blog-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 30px rgba(0,0,0,0.12);
        }

        .blog-image {
            width: 100%;
            height: 250px;
            object-fit: cover;
        }

        .blog-content {
            padding: 2rem;
        }

        .blog-date {
            color: var(--text-muted);
            font-size: 0.85rem;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .blog-title {
            font-size: 1.35rem;
            font-weight: 700;
            color: var(--primary-blue);
            margin-bottom: 1rem;
            line-height: 1.4;
        }

        .blog-excerpt {
            color: var(--text-muted);
            font-size: 0.95rem;
            line-height: 1.7;
            margin-bottom: 1.5rem;
        }

        /* CTA Section */
        .cta-section {
            background: var(--bg-mint);
            padding: 4rem 0;
            text-align: center;
        }

        .cta-content h2 {
            font-size: 2.5rem;
            font-weight: 800;
            color: var(--primary-blue);
            margin-bottom: 2rem;
        }

        .cta-buttons {
            display: flex;
            gap: 1.5rem;
            justify-content: center;
        }

        .btn {
            padding: 1rem 2.5rem;
            border-radius: 10px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            transition: all 0.3s;
            font-size: 1.05rem;
        }

        .btn-primary {
            background: var(--secondary-blue);
            color: white;
        }

        .btn-whatsapp {
            background: #25d366;
            color: white;
        }

        .btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.15);
        }

        /* Contact Section */
        .contact-section {
            background: white;
            padding: 5rem 0;
        }

        .contact-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 2rem;
            margin-top: 3rem;
        }

        .contact-item {
            background: var(--bg-light-blue);
            padding: 2.5rem;
            border-radius: 15px;
            display: flex;
            align-items: center;
            gap: 2rem;
            box-shadow: 0 6px 20px rgba(0,0,0,0.06);
        }

        .contact-icon {
            width: 70px;
            height: 70px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            color: white;
            flex-shrink: 0;
        }

        .icon-blue { background: var(--primary-blue); }
        .icon-green { background: var(--accent-green); }
        .icon-red { background: #ef4444; }

        .contact-info h3 {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--text-dark);
            margin-bottom: 0.5rem;
        }

        .contact-info p {
            color: var(--text-muted);
            font-size: 1rem;
        }

        /* Footer */
        .footer {
            background: var(--primary-blue);
            color: white;
            padding: 3rem 0 1.5rem;
        }

        .footer-content {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 3rem;
            margin-bottom: 2rem;
        }

        .footer h3 {
            font-size: 1.35rem;
            margin-bottom: 1.5rem;
            color: white;
        }

        .footer-links {
            list-style: none;
        }

        .footer-links li {
            margin-bottom: 0.75rem;
        }

        .footer-links a {
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            transition: color 0.3s;
        }

        .footer-links a:hover {
            color: white;
        }

        .social-links {
            display: flex;
            gap: 1rem;
            margin-top: 1.5rem;
        }

        .social-icon {
            width: 40px;
            height: 40px;
            border-radius: 8px;
            background: rgba(255,255,255,0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            text-decoration: none;
            transition: all 0.3s;
        }

        .social-icon:hover {
            background: var(--accent-orange);
            transform: translateY(-3px);
        }

        .footer-bottom {
            border-top: 1px solid rgba(255,255,255,0.1);
            padding-top: 1.5rem;
            text-align: center;
            color: rgba(255,255,255,0.7);
        }

        /* Floating Buttons */
        .floating-buttons {
            position: fixed;
            bottom: 2rem;
            right: 2rem;
            display: flex;
            flex-direction: column;
            gap: 1rem;
            z-index: 999;
        }

        .floating-btn {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.75rem;
            color: white;
            text-decoration: none;
            box-shadow: 0 8px 20px rgba(0,0,0,0.2);
            transition: all 0.3s;
            animation: bounce 2s infinite;
        }

        .btn-whatsapp-float {
            background: #25d366;
        }

        .btn-call-float {
            background: var(--accent-green);
        }

        .floating-btn:hover {
            transform: scale(1.1);
            box-shadow: 0 12px 30px rgba(0,0,0,0.3);
        }

        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% {
                transform: translateY(0);
            }
            40% {
                transform: translateY(-10px);
            }
            60% {
                transform: translateY(-5px);
            }
        }

        /* Responsive */
        @media (max-width: 768px) {
            .mobile-toggle {
                display: block;
            }

            .nav-menu {
                display: none;
            }

            .hero-content,
            .about-content,
            .contact-grid {
                grid-template-columns: 1fr;
            }

            .services-grid,
            .blog-grid {
                grid-template-columns: 1fr;
            }

            .hero h1 {
                font-size: 2rem;
            }

            .section-title {
                font-size: 2rem;
            }

            .footer-content {
                grid-template-columns: 1fr;
            }
        }
    </style>

    @yield('extra-css')
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar">
        <div class="container">
            <div class="nav-content">
                <a href="{{ route('home') }}" class="logo">
                    <img src="/images/logo.png" alt="Journey of Life GCC Logo" onerror="this.style.display='none'">
                    <span class="logo-text">Journey of Life GCC</span>
                </a>
                <ul class="nav-menu">
                    <li><a href="{{ route('home') }}" class="{{ request()->routeIs('home') ? 'active' : '' }}">Home</a></li>
                    <li><a href="{{ route('about') }}" class="{{ request()->routeIs('about') ? 'active' : '' }}">About</a></li>
                    <li><a href="{{ route('services.index') }}" class="{{ request()->routeIs('services.*') ? 'active' : '' }}">Services</a></li>
                    <li><a href="{{ route('blog.index') }}" class="{{ request()->routeIs('blog.*') ? 'active' : '' }}">Blog</a></li>
                    <li><a href="{{ route('contact') }}" class="{{ request()->routeIs('contact') ? 'active' : '' }}">Contact</a></li>
                </ul>
                <div style="display: flex; align-items: center; gap: 1.5rem;">
                    <i class="fas fa-search search-icon"></i>
                    <button class="btn-consultation">
                        <i class="fas fa-phone"></i>
                        Free Consultation
                    </button>
                </div>
                <button class="mobile-toggle">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    @yield('content')

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div>
                    <h3>About Journey of Life GCC</h3>
                    <p>Since 1993, we've been providing free Islamic education and language programs to learners worldwide.</p>
                    <div class="social-links">
                        <a href="#" class="social-icon"><i class="fab fa-whatsapp"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-facebook"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-youtube"></i></a>
                    </div>
                </div>
                <div>
                    <h3>Quick Links</h3>
                    <ul class="footer-links">
                        <li><a href="{{ route('about') }}">About Us</a></li>
                        <li><a href="{{ route('services.index') }}">Our Services</a></li>
                        <li><a href="{{ route('blog.index') }}">Blog</a></li>
                        <li><a href="{{ route('contact') }}">Contact</a></li>
                    </ul>
                </div>
                <div>
                    <h3>Contact Info</h3>
                    <ul class="footer-links">
                        <li><i class="fas fa-map-marker-alt"></i> Al Saya, Kingdom of Bahrain</li>
                        <li><i class="fas fa-phone"></i> +973 33959121</li>
                        <li><i class="fas fa-envelope"></i> info@journeyoflifegcc.com</li>
                        <li><i class="fab fa-whatsapp"></i> +973 33850267</li>
                    </ul>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; 2024 Journey of Life GCC. All Rights Reserved.</p>
            </div>
        </div>
    </footer>

    <!-- Floating Buttons -->
    <div class="floating-buttons">
        <a href="https://wa.me/97333850267" class="floating-btn btn-whatsapp-float" target="_blank">
            <i class="fab fa-whatsapp"></i>
        </a>
        <a href="tel:+97333959121" class="floating-btn btn-call-float">
            <i class="fas fa-phone"></i>
        </a>
    </div>

    @yield('extra-js')
</body>
</html>
