<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('services', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique();
            $table->text('short_description');
            $table->longText('full_description');
            $table->string('featured_image');
            $table->string('icon')->nullable(); // FontAwesome icon
            
            // Course details
            $table->string('duration')->nullable();
            $table->enum('mode', ['Online', 'Offline', 'Both'])->default('Both');
            $table->text('who_can_join')->nullable();
            $table->text('course_highlights')->nullable(); // JSON array
            
            // Status
            $table->boolean('is_active')->default(true);
            $table->integer('order')->default(0);
            
            // SEO
            $table->string('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->string('meta_keywords')->nullable();
            
            $table->timestamps();
            
            $table->index('slug');
            $table->index('is_active');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('services');
    }
};
