# ✅ cPanel Deployment Checklist

## Before Upload
- [ ] Run `composer install --optimize-autoloader --no-dev`
- [ ] Copy `.env.production` to `.env` and configure
- [ ] Run `php artisan key:generate`
- [ ] Test locally one more time
- [ ] Create ZIP of entire project

## In cPanel
- [ ] Create MySQL database
- [ ] Create database user with strong password
- [ ] Add user to database with ALL privileges
- [ ] Note down: database name, username, password

## Upload Files
- [ ] Upload ZIP to public_html
- [ ] Extract ZIP file
- [ ] Delete ZIP file after extraction
- [ ] Set file permissions:
  - [ ] `chmod 755 storage` (recursive)
  - [ ] `chmod 755 bootstrap/cache` (recursive)

## Configure
- [ ] Edit .env file with cPanel database credentials
- [ ] Change document root to `/public_html/public`
  - OR create .htaccess redirect
- [ ] Run migrations via Terminal:
  - [ ] `php artisan migrate --force`
  - [ ] `php artisan db:seed --force`
- [ ] Create storage link: `php artisan storage:link`
- [ ] Cache config: `php artisan config:cache`

## Email Setup
- [ ] Create email account: noreply@journeyoflifegcc.com
- [ ] Update .env with email credentials
- [ ] Test contact form

## SSL & Security
- [ ] Install SSL certificate (AutoSSL)
- [ ] Force HTTPS in .htaccess
- [ ] Set APP_DEBUG=false
- [ ] Set APP_ENV=production

## Test Website
- [ ] Visit https://journeyoflifegcc.com
- [ ] Test all pages load
- [ ] Test contact form sends email
- [ ] Login to admin panel
- [ ] Change admin password
- [ ] Upload service images
- [ ] Create first blog post

## Final Steps
- [ ] Clear all caches
- [ ] Test on mobile
- [ ] Test floating buttons (WhatsApp, Call)
- [ ] Submit to Google Search Console
- [ ] Add Google Analytics (optional)

## Backup
- [ ] Set up automatic backups in cPanel
- [ ] Download initial backup locally

---

## Quick Commands Reference

```bash
# Navigate to project
cd /home/username/public_html

# Migrations
php artisan migrate --force
php artisan db:seed --force

# Cache
php artisan config:cache
php artisan route:cache
php artisan view:cache

# Clear cache
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear

# Storage link
php artisan storage:link

# Check PHP version
php -v
```

## Default Login
- URL: https://journeyoflifegcc.com/admin
- Email: admin@journeyoflifegcc.com
- Password: password
- **⚠️ CHANGE IMMEDIATELY AFTER FIRST LOGIN!**

## Support Contact
If you need help:
- Check: CPANEL-DEPLOYMENT-GUIDE.md
- Laravel logs: storage/logs/laravel.log
- Enable debug temporarily: APP_DEBUG=true

---

**Ready to go live! 🚀**
