# 🚀 cPanel Deployment Guide - Journey of Life GCC

## 📋 Pre-Deployment Checklist

Before uploading to cPanel, make sure you have:
- ✅ cPanel login credentials
- ✅ Domain name (journeyoflifegcc.com)
- ✅ MySQL database access
- ✅ FTP/File Manager access
- ✅ PHP 8.1+ enabled on server

---

## 🔧 Step-by-Step Deployment Process

### Step 1: Prepare Your Files Locally

1. **Extract the ZIP file**
2. **Open terminal in project folder**
3. **Install dependencies:**
```bash
composer install --optimize-autoloader --no-dev
```

4. **Create production .env file:**
```bash
cp .env.example .env
```

5. **Edit .env file for production:**
```env
APP_NAME="Journey of Life GCC"
APP_ENV=production
APP_KEY=base64:YOUR_KEY_HERE
APP_DEBUG=false
APP_URL=https://journeyoflifegcc.com

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=your_cpanel_database_name
DB_USERNAME=your_cpanel_database_user
DB_PASSWORD=your_cpanel_database_password

MAIL_MAILER=smtp
MAIL_HOST=mail.journeyoflifegcc.com
MAIL_PORT=587
MAIL_USERNAME=noreply@journeyoflifegcc.com
MAIL_PASSWORD=your_email_password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=noreply@journeyoflifegcc.com
MAIL_FROM_NAME="Journey of Life GCC"
```

6. **Generate application key:**
```bash
php artisan key:generate
```

7. **Optimize for production:**
```bash
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

---

### Step 2: Create Database in cPanel

1. **Login to cPanel**
2. **Go to:** MySQL Databases
3. **Create new database:**
   - Database name: `journey_of_life`
4. **Create database user:**
   - Username: `journey_user`
   - Password: (Generate strong password)
5. **Add user to database:**
   - Select user
   - Select database
   - Grant ALL PRIVILEGES

**Important:** Note down these credentials for .env file!

---

### Step 3: Upload Files to cPanel

#### Option A: Using File Manager (Recommended for beginners)

1. **Login to cPanel**
2. **Go to:** File Manager
3. **Navigate to:** `public_html` folder
4. **Create ZIP of your Laravel project** (all files except node_modules)
5. **Upload ZIP file** to public_html
6. **Extract ZIP** using File Manager
7. **Your structure should be:**
```
public_html/
├── app/
├── bootstrap/
├── config/
├── database/
├── public/
├── resources/
├── routes/
├── storage/
├── vendor/
├── .env
├── artisan
└── composer.json
```

#### Option B: Using FTP (Faster for large files)

1. **Use FileZilla or any FTP client**
2. **Connect to:**
   - Host: ftp.journeyoflifegcc.com
   - Username: Your cPanel username
   - Password: Your cPanel password
3. **Upload entire Laravel folder** to `public_html`

---

### Step 4: Configure Document Root

**CRITICAL:** Laravel's public folder must be the document root!

**Method 1: Using .htaccess (If you can't change document root)**

1. **Create `.htaccess` in public_html root:**
```apache
<IfModule mod_rewrite.c>
    RewriteEngine On
    RewriteRule ^(.*)$ public/$1 [L]
</IfModule>
```

**Method 2: Change Document Root (Recommended)**

1. **Login to cPanel**
2. **Go to:** Domains
3. **Click:** Manage (next to your domain)
4. **Change Document Root to:** `/public_html/public`
5. **Save**

---

### Step 5: Set File Permissions

**Using File Manager:**

1. **Select these folders:**
   - `storage`
   - `bootstrap/cache`
2. **Right-click → Change Permissions**
3. **Set to:** `755` for folders, `644` for files
4. **Check:** "Recurse into subdirectories"

**Or via SSH (if available):**
```bash
chmod -R 755 storage
chmod -R 755 bootstrap/cache
```

---

### Step 6: Run Database Migrations

#### Option A: Using SSH (If available)

```bash
cd /home/yourusername/public_html
php artisan migrate --force
php artisan db:seed --force
```

#### Option B: Using cPanel Terminal

1. **Go to:** cPanel → Terminal
2. **Run commands:**
```bash
cd public_html
php artisan migrate --force
php artisan db:seed --force
```

#### Option C: Import SQL manually

1. **Export from local:**
```bash
php artisan migrate
mysqldump -u root -p journey_of_life > database.sql
```

2. **Import in cPanel:**
   - Go to phpMyAdmin
   - Select your database
   - Click Import
   - Upload database.sql

---

### Step 7: Configure .env File on Server

1. **File Manager → Edit .env**
2. **Update these values:**
```env
APP_ENV=production
APP_DEBUG=false
APP_URL=https://journeyoflifegcc.com

DB_CONNECTION=mysql
DB_HOST=localhost
DB_DATABASE=cpanel_username_journey_of_life
DB_USERNAME=cpanel_username_journey_user
DB_PASSWORD=your_password_from_step2
```

3. **Save file**

---

### Step 8: Clear Caches

**Via Terminal:**
```bash
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
```

**Then cache for production:**
```bash
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

---

### Step 9: Create Storage Link

```bash
php artisan storage:link
```

**If command doesn't work, create manually:**
1. **In public folder, create symlink:**
   - From: `/home/username/public_html/storage/app/public`
   - To: `/home/username/public_html/public/storage`

---

### Step 10: Install SSL Certificate (IMPORTANT!)

1. **cPanel → SSL/TLS Status**
2. **Click:** "Run AutoSSL" (Free Let's Encrypt)
3. **Wait for installation**
4. **Force HTTPS - Create .htaccess in public folder:**

```apache
<IfModule mod_rewrite.c>
    RewriteEngine On
    
    # Force HTTPS
    RewriteCond %{HTTPS} off
    RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
    
    # Handle Authorization Header
    RewriteCond %{HTTP:Authorization} .
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]

    # Redirect Trailing Slashes If Not A Folder...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_URI} (.+)/$
    RewriteRule ^ %1 [L,R=301]

    # Send Requests To Front Controller...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteRule ^ index.php [L]
</IfModule>
```

---

### Step 11: Configure Email (For Contact Form)

1. **cPanel → Email Accounts**
2. **Create email:**
   - Email: noreply@journeyoflifegcc.com
   - Password: (Strong password)
3. **Update .env:**
```env
MAIL_MAILER=smtp
MAIL_HOST=mail.journeyoflifegcc.com
MAIL_PORT=587
MAIL_USERNAME=noreply@journeyoflifegcc.com
MAIL_PASSWORD=your_email_password
MAIL_ENCRYPTION=tls
```

---

### Step 12: Test Your Website

1. **Visit:** https://journeyoflifegcc.com
2. **Test pages:**
   - ✅ Home page loads
   - ✅ About page
   - ✅ Services page
   - ✅ Blog page
   - ✅ Contact form works
3. **Test admin:**
   - Visit: https://journeyoflifegcc.com/admin
   - Login with: admin@journeyoflifegcc.com / password
   - **CHANGE PASSWORD IMMEDIATELY!**

---

## 🔒 Security Checklist

After deployment:

- [ ] Change admin password
- [ ] Set `APP_DEBUG=false`
- [ ] Set `APP_ENV=production`
- [ ] Enable SSL certificate
- [ ] Remove .git folder (if uploaded)
- [ ] Set proper file permissions
- [ ] Enable firewall in cPanel
- [ ] Set up regular backups

---

## 📧 Configure Contact Form Email

**Update admin email in database:**

```sql
UPDATE users SET email='youremail@journeyoflifegcc.com' WHERE id=1;
```

**Test contact form:**
1. Visit contact page
2. Submit test message
3. Check if email arrives

---

## 🎨 Upload Your Images

1. **Logo:**
   - Upload to: `/public/images/logo.png`
   - Size: 200x80px recommended

2. **Service Images:**
   - Upload to: `/storage/app/public/services/`
   - Run: `php artisan storage:link`

3. **Blog Images:**
   - Upload via admin panel
   - Or manually to: `/storage/app/public/blog/`

---

## 🔧 Common Issues & Solutions

### Issue 1: 500 Internal Server Error
**Solution:**
```bash
chmod -R 755 storage bootstrap/cache
php artisan cache:clear
```

### Issue 2: Database Connection Error
**Solution:**
- Check .env credentials
- Ensure database exists
- Check MySQL user has privileges

### Issue 3: CSS/JS Not Loading
**Solution:**
- Clear browser cache
- Check APP_URL in .env
- Force HTTPS in .htaccess

### Issue 4: Images Not Displaying
**Solution:**
```bash
php artisan storage:link
chmod -R 755 storage/app/public
```

### Issue 5: Routes Not Working
**Solution:**
```bash
php artisan route:clear
php artisan config:clear
```

---

## 📊 Performance Optimization

**After deployment, optimize:**

1. **Enable OPcache** (in cPanel → Select PHP Version → Options)
2. **Enable Gzip compression**
3. **Optimize images** before upload
4. **Cache config:**
```bash
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

---

## 🔄 How to Update Website

**When you need to update content:**

1. **Login to admin:** https://journeyoflifegcc.com/admin
2. **Update content** (Services, Blog, Pages)
3. **No need to upload files again!**

**When you need to update code:**

1. Make changes locally
2. Upload only changed files via FTP
3. Clear caches:
```bash
php artisan cache:clear
php artisan config:clear
```

---

## 📱 Post-Deployment Checklist

- [ ] Website loads correctly
- [ ] All pages accessible
- [ ] SSL certificate active (https://)
- [ ] Contact form sends emails
- [ ] Admin panel accessible
- [ ] Images uploading works
- [ ] Services displaying correctly
- [ ] Blog posts working
- [ ] WhatsApp button working
- [ ] Call button working
- [ ] Google Analytics added (optional)

---

## 🆘 Need Help?

**If you encounter issues:**

1. **Check Laravel logs:**
   - File Manager → storage/logs/laravel.log

2. **Enable debug mode temporarily:**
   - Set `APP_DEBUG=true` in .env
   - Visit site to see error
   - Set back to `false` after fixing

3. **Check PHP version:**
   - cPanel → Select PHP Version
   - Must be 8.1 or higher

4. **Contact host support** if server-related issues

---

## 📝 Important Files Locations

```
public_html/
├── .env                          (Configuration)
├── public/                       (Web root - set as document root)
│   ├── index.php                (Entry point)
│   ├── .htaccess               (URL rewriting)
│   └── images/                  (Your uploaded images)
├── storage/
│   ├── app/public/             (Public uploads)
│   └── logs/laravel.log        (Error logs)
└── database/
    ├── migrations/              (Database structure)
    └── seeders/                 (Sample data)
```

---

## ✅ Final Step: Go Live!

**Once everything is tested:**

1. Update DNS if needed (point to your server)
2. Remove any "Under Construction" pages
3. Announce your website launch! 🎉

**Your website is now LIVE at:**
https://journeyoflifegcc.com

---

**May Allah bless your educational efforts! 🤲**

*Journey of Life GCC - Empowering Lives Through Knowledge*
